/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2020 Abovo Media (http://www.abovomedia.nl)
 * @package    totem/theme-frontend-base
 * @comment    Mixin to auto select a single option and update the stock information for swatches
 */

define(['jquery'],function ($) {
   'use strict';
   
   return function (widget) {
      $.widget('mage.SwatchRenderer', widget, {
         _init: function () {
            // Don't render the same set of swatches twice
            if ($(this.element).attr('data-rendered')) {
               return;
            }
            $(this.element).attr('data-rendered', true);
            
            if (_.isEmpty(this.options.jsonConfig.images)) {
               this.options.useAjax = true;
               // creates debounced variant of _LoadProductMedia()
               // to use it in events handlers instead of _LoadProductMedia()
               this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);
            }
            
            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {
               // store unsorted attributes
               this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);
               this._sortAttributes();
               this._RenderControls();
               this._setPreSelectedGallery();
               $(this.element).trigger('swatch.initialized');
               
               /* TOTEM: auto select single option */
               if($('.page-product-configurable #product-options-wrapper .swatch-attribute').length >= 1) {
                  $('.page-product-configurable #product-options-wrapper .swatch-attribute').each(function() {
                     if($(this).find('.swatch-option:not([disabled="disabled"])').length == 1) {
                        $(this).find('.swatch-option:not([disabled="disabled"])').first().trigger('click');
                     }
                  });
               }
               /* TOTEM: auto select single option */
            } else {
               console.log('SwatchRenderer: No input data received');
            }
            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();
         },
         
         /**
          * Event for swatch options
          *
          * @param {Object} $this
          * @param {Object} $widget
          * @private
          */
         _OnClick: function ($this, $widget) {
            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),
                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),
                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),
                attributeId = $parent.attr('attribute-id'),
                $input = $parent.find('.' + $widget.options.classes.attributeInput),
                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']);
            
            if ($widget.inProductList) {
               $input = $widget.productForm.find(
                  '.' + $widget.options.classes.attributeInput + '[name="super_attribute[' + attributeId + ']"]'
               );
            }
            
            if ($this.hasClass('disabled')) {
               return;
            }
            
            if ($this.hasClass('selected')) {
               $parent.removeAttr('option-selected').find('.selected').removeClass('selected');
               $input.val('');
               $label.text('');
               $this.attr('aria-checked', false);
            } else {
               $parent.attr('option-selected', $this.attr('option-id')).find('.selected').removeClass('selected');
               $label.text($this.attr('option-label'));
               $input.val($this.attr('option-id'));
               $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));
               $this.addClass('selected');
               $widget._toggleCheckedAttributes($this, $wrapper);
            }
            
            $widget._Rebuild();
            
            // TOTEM: custom stock message
            if(typeof updateSwatchStock !== 'undefined') {
               var swatchAttributeSelector               = $widget.options.classes.attributeClass;
               var swatchAttributeOptionsWrapperSelector = $widget.options.classes.attributeOptionsWrapper;
               var $swatchAttributes                     = $('#product-options-wrapper .' + swatchAttributeSelector);
               var allOptionsValid                       = true;
               
               $swatchAttributes.each(function(){
                  var $this          = $(this);
                  var attributeValue = $this.attr('option-selected');
                  
                  if(typeof attributeValue === 'undefined') {
                     var $attributeOptionsWrapper = $this.find('.' + swatchAttributeOptionsWrapperSelector);
                     var optionRequired           = $attributeOptionsWrapper.attr('aria-required');
                     
                     if(optionRequired == 'true') {
                        allOptionsValid = false;
                     }
                  }
               });
               
               if(allOptionsValid) {
                  var stock           = $widget.options.jsonConfig['stock'][this.getProduct()];
                  var parentProductId = $widget.options.jsonConfig['productId'];
                  var $stockEl        = $('[data-role="stock-' + parentProductId + '"]');
                  var $stockMessageEl = $('[data-role="stock-message-' + parentProductId + '"]');
                  
                  if(typeof stock !== 'undefined') {
                     if(stock.qty > 0 || stock.backorder == 1) {
                        $stockEl.removeClass('unavailable').addClass('available');
                        $stockMessageEl.removeClass('unavailable').addClass('available');
                        if(typeof stockAvailableMessage !== 'undefined') {
                           $($stockEl).find('span').text(stockAvailableMessage);
                        }
                        if(typeof inStockMessage !== 'undefined') {
                           $stockMessageEl.text(inStockMessage);
                        }
                     }
                     else if(stock.qty < 1 && stock.backorder == 2) {
                        $stockEl.removeClass('available').addClass('unavailable');
                        $stockMessageEl.removeClass('available').addClass('unavailable');
                        if(typeof stockBackorderMessage !== 'undefined') {
                           $($stockEl).find('span').text(stockBackorderMessage);
                        }
                        if(typeof backorderMessage !== 'undefined') {
                           $stockMessageEl.text(backorderMessage);
                        }
                     }
                     else {
                        $stockEl.removeClass('available').addClass('unavailable');
                        $stockMessageEl.removeClass('available').addClass('unavailable');
                        if(typeof stockUnavailableMessage !== 'undefined') {
                           $($stockEl).find('span').text(stockUnavailableMessage);
                        }
                        if(typeof outOfStockMessage !== 'undefined') {
                           $stockMessageEl.text(outOfStockMessage);
                        }
                     }
                  }
               }
            }
            // TOTEM: custom stock message
            
            if ($widget.element.parents($widget.options.selectorProduct)
                       .find(this.options.selectorProductPrice).is(':data(mage-priceBox)')
            ) {
               $widget._UpdatePrice();
            }
            
            $(document).trigger('updateMsrpPriceBlock',
                                [
                                   _.findKey($widget.options.jsonConfig.index, $widget.options.jsonConfig.defaultValues),
                                   $widget.options.jsonConfig.optionPrices
                                ]);
            
            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {
               $widget._loadMedia();
            }
            
            $input.trigger('change');
         }
      });
      
      return $.mage.SwatchRenderer;
   };
});