/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2020 Abovo Media (http://www.abovomedia.nl)
 * @package    totem/theme-frontend-base
 */

define([
   'jquery',
   'jquery-ui-modules/widget',
   'jquery-ui-modules/core',
   'jquery/jquery-storageapi',
   'mage/mage'
       ], function ($) {
   return function (widget) {
      $.widget('mage.collapsible', widget, {
         /**
          * @private
          */
         _create: function() {
            this.storage = $.localStorage;
            this.icons = false;
         
            if(typeof this.options.icons === 'string') {
               this.options.icons = $.parseJSON(this.options.icons);
            }
         
            this._processPanels();
            this._processState();
            this._refresh();
         
            if(this.options.icons.header && this.options.icons.activeHeader) {
               this._createIcons();
               this.icons = true;
            }
         
            this.element.on('dimensionsChanged', function(e) {
               if(e.target && e.target.classList.contains('active')) {
                  //this._scrollToTopIfVisible(e.target); //2.3.3
                  //this._scrollToTopIfNotVisible(); //2.3.4
               }
            }.bind(this));
         
            this._bind('click');
            this._trigger('created');
         }
      });
   };
   
   return $.mage.collapsible;
});