/**
 * @author     Floris Jansen
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    totem/theme-frontend-base
 */

fotoramaDefaults = {
   thumbmargin: 20
}

require(['jquery', 'base64', 'owl.carousel', 'modernizr-custom', 'priceBox'], function($, base64){
   var delta                     = 0;
   var lastScrollTop             = 0;
   var lastClicked               = null;
   var dragging                  = false;
   var $currentActiveRoot        = $('#main-nav li.level-root.active');
   var resizeTimer               = null;
   var windowHeight              = 0;
   var scroller                  = document.getElementsByClassName('scroller')[0];
   var filterScroller            = document.getElementsByClassName('filter-content')[0];
   var _clientY                  = null;
   var addToCartButtonOffset     = 0;
   var topReached                = true;
   var st                        = 0;
   var scrollTopTimer            = false;
   var oldWindowWidth            = $(window).width();
   var lazyBgTimer               = 0;
   var lazyBgResizeTimer         = 0;
   var win                       = $(window);
   var lazyBgElements            = $('[data-bg-image]');
   
   window.didScroll              = false;
   window.allowScrollCheck       = false;
   
   $('.column.main .price-box.price-final_price').on('reloadPrice', function(){
      var priceBoxHtml          = $('.column.main .price-box.price-final_price').prop('outerHTML');
      var $stickyPriceboxHolder = $('.sticky-pricebox-holder');
      
      if($stickyPriceboxHolder.length > 0) {
         $stickyPriceboxHolder.html(priceBoxHtml.replace('price-box','price-box-clone'));
      }
   });
   
   // DOM ready
   $(function(){
      if($('#product-addtocart-button').length > 0) {
         var addToCartButton = true;
      } else {
         var addToCartButton = false;
      }
      
      $.fn.owlCarouselSameHeight = function($carouselElement) {
         $carouselElement.find('.owl-item').height('');
         $carouselElement.find('.owl-item').height($carouselElement.find('.owl-stage-outer').height());
      }
      
      $.fn.initOwlCarousel = function($target)
      {
         var $that            = $target;
         var $carouselElement = $that.find($that.data('owlCarouselElement'));
         var carouselSettings = $that.data('owlCarouselSettings');
         var carouselClass    = $that.data('owlCarouselClass');
   
         if(carouselSettings != '') {
            carouselSettings = $.parseJSON(base64.decode(carouselSettings));
         } else {
            carouselSettings = {};
         }
   
         carouselSettings.stagePadding          = 15;
         carouselSettings.responsiveBaseElement = '#' + $that.attr('id');
   
         $carouselElement.addClass(carouselClass);
   
         $carouselElement.on('drag.owl.carousel translate.owl.carousel', function(event) {
            $that.addClass('dragging');
         });
   
         $carouselElement.on('dragged.owl.carousel initialized.owl.carousel translated.owl.carousel', function(event) {
            $that.removeClass('dragging');
      
            var max = event.item.count;
            var cur = event.item.index;
            var perPage = event.page.size;
      
            if(cur + perPage == max) {
               $that.addClass('hide-next');
            } else {
               $that.removeClass('hide-next');
            }
      
            if(event.item.index == 0) {
               $that.addClass('hide-prev');
            } else {
               $that.removeClass('hide-prev');
            }
         });
   
         if(carouselSettings.sameHeight) {
            $carouselElement.on('refreshed.owl.carousel', function() {
               $.fn.owlCarouselSameHeight($carouselElement);
            });
      
            $carouselElement.on('initialized.owl.carousel', function() {
               setTimeout(function() {
                  $.fn.owlCarouselSameHeight($carouselElement);
               }, 1000);
            });
      
            $(document).on('swatch.initialized', function() {
               $.fn.magentoSwatchesLoaded($carouselElement);
            });
         }
   
         $that.addClass('carousel-loaded');
         $carouselElement.owlCarousel(carouselSettings);
      }
      
      //Init Owl Carousels
      $("[data-owl-carousel-element]").each(function() {
         $.fn.initOwlCarousel($(this));
      });
      
      
      $.fn.magentoSwatchesLoaded = function($carouselElement)
      {
         clearTimeout($carouselElement.magentoSwatchesLoadedTimer);
         
         $carouselElement.magentoSwatchesLoadedTimer = setTimeout(function() {
            $.fn.owlCarouselSameHeight($carouselElement);
         }, 100);
      }
      
      $.fn.hasScrolled = function() {
         
         if(st != 0 && Math.abs(lastScrollTop - st) <= delta) {
            return;
         }
         
         if(addToCartButton) {
            addToCartButtonOffset = $('#product-addtocart-button').offset().top;
         }
         
         if (st > lastScrollTop && st >= window.scrollTopOffset){
            // Scroll Down
            $('html').addClass('scrolled').removeClass('header-static').addClass('header-sticky');
            
            if(addToCartButton && st > addToCartButtonOffset)
            {
               $('html').addClass('show-add-to-cart');
            }
         } else {
            
            // Scroll Up
            if(addToCartButton && st <= addToCartButtonOffset)
            {
               $('html').removeClass('show-add-to-cart');
            }
            
            if(st <= window.scrollTopOffset) {
               $('html').removeClass('scrolled').removeClass('header-sticky').addClass('header-static');
            }
            
         }
         
         lastScrollTop = st;
      }
      
      $.fn.setNavElementMargins = function() {
         
         $.fn.setMobileScrollerHeight();
         
         window.allowScrollCheck = false;
         
         $('html').removeClass('header-static').removeClass('header-sticky').removeClass('scrolled');
         
         $('html, .main-nav-wrapper, .header-mobile').css('margin-top', 0);
         
         var navHeaderHeight = $('.header-wrapper').height();
         $('html').css('margin-top', navHeaderHeight);
         
         var pageHeaderHeight = $('.page-header').height();
         $('.main-nav-wrapper').css('margin-top', pageHeaderHeight);
         $('.header-mobile').css('margin-top', pageHeaderHeight);
         
         if($(window).scrollTop() > 0) {
            $('html').addClass('header-sticky').addClass('scrolled');
         } else {
            $('html').addClass('header-static');
         }
         
         window.scrollTopOffset = $('.page-header .panel.header').height();
         window.allowScrollCheck = true;
      }
      
      $.fn.setMobileScrollerHeight = function() {
         
         $('.scroller').css('height', 'auto');
         
         if($('html').hasClass('touchevents') && $('html').hasClass('mobile-nav-open')) {
            if(window.innerHeight != windowHeight) {
               height = window.innerHeight;
               $('.scroller').css('height', height + 'px');
            }
         }
         
         if($('html').hasClass('touchevents') && $('html').hasClass('mobile-filter-open')) {
            if(window.innerHeight != windowHeight) {
               height = window.innerHeight;
               $('.filter-scroller').css('height', height + 'px');
            }
         }
      }
      
      /**
       * DESKTOP FUNCTIONS
       */
      
      $('#main-nav li.level-root:not(.active)').on('mouseenter', function(e){
         if($('#main-nav-open').is(':hidden')) {
            $('#main-nav li.level-root.active').removeClass('active');
         }
      });
      
      $('#main-nav li.level-root:not(.active)').on('mouseleave', function(e){
         if($('#main-nav-open').is(':hidden')) {
            $currentActiveRoot.addClass('active');
         }
      });
      
      /**
       * MOBILE FUNCTIONS
       */
      
      if($('#main-nav li.level-root > a').length > 0) {
         $('#main-nav').addClass('has-root-links');
      }
      
      $('body').on('click', '#main-nav li.level-root.parent:not(.active)', function(e){
         if($('#main-nav-open').is(':visible')) {
            e.preventDefault();
            $('#main-nav li.level-root.active').removeClass('active');
            $(this).addClass('active');
         }
      });
      
      $('#main-nav-open').on('click', function(e){
         $('html').addClass('mobile-nav-open');
         $.fn.setMobileScrollerHeight();
      });
      
      $('body').on('click', '#filter-open', function(e){
         $('html').addClass('mobile-filter-open');
         $.fn.setMobileScrollerHeight();
      });
      
      $('.mobile-nav-overlay, .mobile-nav-overlay-close').on('click', function(e){
         if($('html').hasClass('mobile-nav-open')) {
            $('html').removeClass('mobile-nav-open');
         } else if($('html').hasClass('mobile-filter-open')) {
            $('html').removeClass('mobile-filter-open');
         }
      });
      
      $('.submenu-indicator').on('click', function(e){
         
         var $parentEl = $(this).closest('li');
         var $siblings = $parentEl.siblings('li')
         
         $siblings.removeClass('open');
         $parentEl.toggleClass('open');
         $siblings.find('li.open').removeClass('open');
         
      });
      
      $('#main-nav li.active').addClass('open');
      
      // Ceck if dragging (scroll) on body
      
      $('html.touchevents body').on('touchmove', function(e){
         dragging = true;
      });
      
      $('html.touchevents body').on('touchstart', function(){
         dragging = false;
      });
      
      // scroll element on mobile device
      
      if(scroller) {
         addScrollerEvents(scroller);
      }
      
      if(filterScroller) {
         addScrollerEvents(filterScroller);
      }
      
      function addScrollerEvents(_scrollerElement) {
         _scrollerElement.addEventListener('touchstart', function(event) {
            if(event.targetTouches.length === 1) {
               // detect single touch
               _clientY = event.targetTouches[0].clientY;
            }
         }, {passive: true}, false);
         
         _scrollerElement.addEventListener('touchmove', function(event) {
            if(event.targetTouches.length === 1) {
               // detect single touch
               disableRubberBand(event, _scrollerElement);
            }
         }, {passive: true}, false);
      }
      
      function disableRubberBand(event, _scrollerElement) {
         var clientY = event.targetTouches[0].clientY - _clientY;
         
         if (_scrollerElement.scrollTop === 0 && clientY > 0) {
            // element is at the top of its scroll
            event.preventDefault();
         }
         
         if (isOverlayTotallyScrolled(_scrollerElement) && clientY < 0) {
            //element is at the top of its scroll
            event.preventDefault();
         }
      }
      
      function isOverlayTotallyScrolled(_scrollerElement) {
         return _scrollerElement.scrollHeight - _scrollerElement.scrollTop <= _scrollerElement.clientHeight;
      }
      
      /**
       * DESKTOP AND MOBILE FUNCTIONS
       */
      
      $('html.touchevents #main-nav li.level-root > a, html.touchevents #main-nav li.level-0.parent > a').on('touchend',function(e) {
         if($('#main-nav-open').is(':hidden')) {
            var li  = $(this).closest('li').get(0);
            var $li = $(li);
            
            if(!dragging) {
               
               if($li.hasClass('level-root')) {
                  $('body').unbind('touchend');
                  $('#main-nav li.level-root.active').removeClass('active');
                  $('#main-nav li.level-root.hover').removeClass('hover');
               }
               
               $('#main-nav li.level-0.hover').removeClass('hover');
               
               if(lastClicked !== li) {
                  
                  e.preventDefault();
                  
                  $li.toggleClass('hover');
                  lastClicked = li;
                  
                  $('body').bind('touchend', function(e) {
                     if(!dragging) {
                        var target = $(e.target);
                        
                        if(target.closest('#main-nav').length == 0) {
                           $('#main-nav li.hover').removeClass('hover');
                           $('body').unbind('touchend');
                           
                           $currentActiveRoot.addClass('active');
                           
                           lastClicked = false;
                        }
                     }
                  });
               }
            }
         }
      });
      
      $('.sticky-add-to-cart .tocart').on('click', function(e){
         e.preventDefault();
         
         var top = $('.product-add-form').offset().top - $('.page-header .header.content').outerHeight() - 30;
         
         $(window).scrollTop(top);
         
         $('.product-add-form button.tocart').trigger('click');
      });
      
      $('.catalog-product-view .reviews-actions a').click(function (event) {
         var anchor;
         
         event.preventDefault();
         anchor = $(this).attr('href').replace(/^.*?(#|$)/, '');
         $('.product.data.items [data-role="content"]').each(function (index) {
            if (this.id == 'reviews') {
               $('.product.data.items').tabs('activate', index);
               
               var stickyAddToCartHeight = 0;
               
               if($('.sticky-add-to-cart').length > 0) {
                  stickyAddToCartHeight =  $('.sticky-add-to-cart .inner').outerHeight();
               }
               
               $('html, body').animate({
                  scrollTop: $('#' + anchor).offset().top - ($('.page-header .header.content').outerHeight() + stickyAddToCartHeight)
               }, 300);
            }
         });
      });
      
      $(window).scrollTop(-1);
      
      $(window).scroll(function(event){
         st = $(window).scrollTop();
         
         if(st > 0) {
            topReached = false;
         }
         
         window.didScroll = true;
         
         $.fn.hasScrolled();
   
         clearTimeout(scrollTopTimer);
         
         if(st <= 0) {
            scrollTopTimer = setTimeout(function() {
               $.fn.setNavElementMargins();
            }, 100);
         }
      });
      
      $(window).on('resize', function(e) {
         clearTimeout(resizeTimer);
         
         resizeTimer = setTimeout(function() {
            if($(window).width() != oldWindowWidth) {
               $.fn.setNavElementMargins();
   
               oldWindowWidth = $(window).width();
            }
         }, 200);
      });
      
      $.fn.setNavElementMargins();
      
      $(window).on('orientationchange', function(event) {
         $('html.mobile-nav-open').removeClass('mobile-nav-open');
         $.fn.setNavElementMargins();
      });
      
   });
   
   $.fn.visible = function() {
      var $t                = $(this);
      var $w                = $(window);
      var top_of_element    = $t.offset().top;
      var bottom_of_element = $t.offset().top + $t.outerHeight();
      var bottom_of_screen  = $w.scrollTop() + $w.innerHeight();
      var top_of_screen     = $w.scrollTop();
      var offset            = $(window).height() * 0.6;
      
      if ((bottom_of_screen > top_of_element - offset) && (top_of_screen < bottom_of_element + offset)){
         return true;
      } else {
         return false;
      }
   };
   
   $.fn.setLazyBg = function() {
      this.each(function(){
         var $this = $(this);
         $this.css("background-image", "url('" + $this.data('bgImage') + "')");
      });
   }
   
   $(window).on('resize', function(e) {
      clearTimeout(lazyBgResizeTimer);
      lazyBgResizeTimer = setTimeout(function() {
         checkLazyBgElements();
      }, 250);
   });
   
   function checkLazyBgElements() {
      lazyBgElements.each(function(i, el) {
         var el = $(el);
         if(!el.hasClass('already-visible') && el.visible()) {
            el.setLazyBg();
            el.addClass("already-visible");
         }
      });
   }
   
   win.scroll(function() {
      clearTimeout(lazyBgTimer);
      lazyBgTimer = setTimeout(function() {
         checkLazyBgElements();
      }, 250);
   });
   
   checkLazyBgElements();
});