<?php
/**
 * @author     Koen Slagter
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widget
 */

namespace Totem\Widgets\Setup;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeData implements UpgradeDataInterface
{
   /**
    * Eav Setup Factory.
    *
    * @var EavSetupFactory
    */
   private $eavSetupFactory;
   
   /**
    * Init.
    *
    * @param EavSetupFactory $eavSetupFactory
    */
   public function __construct(
      EavSetupFactory $eavSetupFactory
   ) {
      $this->eavSetupFactory = $eavSetupFactory;
   }
   
   /**
    * {@inheritdoc}
    *
    * Add an image role attribute to be used in the products grid widget
    *
    * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
    */
   public function upgrade(
      ModuleDataSetupInterface $setup,
      ModuleContextInterface $context
   ) {
      /** @var EavSetupFactory $eavSetup */
      $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);

      if (version_compare($context->getVersion(), '1.0.1', '<')):
         $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'detail_image',
            [
               'type'                     => 'varchar',
               'label'                    => 'Detail',
               'input'                    => 'media_image',
               'frontend'                 => 'Magento\Catalog\Model\Product\Attribute\Frontend\Image',
               'global'                   => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
               'filterable'               => false,
               'visible_on_front'         => false,
               'used_in_product_listing'  => true,
               'sort_order'               => 10,
               'required'                 => false,
            ]
         );
   
         $entityTypeId = $eavSetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
         $attributeSetIds = $eavSetup->getAllAttributeSetIds($entityTypeId);
         foreach ($attributeSetIds as $attributeSetId) :
            $groupId = $eavSetup->getAttributeGroupId($entityTypeId, $attributeSetId, "image-management");
            $eavSetup->addAttributeToGroup(
               $entityTypeId,
               $attributeSetId,
               $groupId,
               'detail_image',
               null
            );
         endforeach;
         
      endif;
   }
}