<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Plugin;

class WidgetPlugin
{
   protected $allowedWidgets = [
      'cms_static_block',
      'totem_widget_banner',
      'totem_widget_categories_slider',
      'totem_widget_newsletter',
      'totem_widget_products_grid',
      'totem_widget_products_list',
      'totem_widget_products_slider',
      'totem_widget_title',
      'totem_widget_usp',
      'totem_widget_video',
      'wysiwyg_widget',
      'magefan_blog_recent'
   ];
   
   /**
    * Change widgets array and to only allow specific widgets
    *
    * @param array $result Key-value array of filters for widget node properties
    *
    * @return array
    */
   public function afterGetWidgetsArray(\Magento\Widget\Model\Widget $subject, $result)
   {
      foreach($result as $key => $widget):
         if(!in_array($widget['code'], $this->allowedWidgets)):
            unset($result[$key]);
         endif;
      endforeach;
      
      return $result;
   }
}