<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class Data extends AbstractHelper
{
   const OEMBED_EXTRA_URL_PARAMS = [
      'youtube' => ['rel' => '0']
   ];
   
   /**
    * Get unique id
    *
    * @return string
    */
   public function getUniqueId()
   {
      return md5(uniqid(rand(), true));
   }
   
   /**
    * Add params to an embed url
    *
    * @param $html
    *
    * @return string|string[]|null
    */
   public function addParamsEmbedUrl($html)
   {
      preg_match('/src="(.*?)"/', $html, $matches);
      
      if(empty($matches) || !isset($matches[1])):
         return $html;
      endif;
      
      $oembedUrl = $matches[1];
      $urlParams = '';
      
      foreach(self::OEMBED_EXTRA_URL_PARAMS as $domain => $params):
         if(false === strpos($oembedUrl, $domain)):
            continue;
         endif;
         
         foreach($params as $key => $param):
            $separator = '&';
            if($key == array_key_first($params) && !parse_url($oembedUrl, PHP_URL_QUERY)):
               $separator = '?';
            endif;
            
            $urlParams .= $separator . $key . '=' . $param;
         endforeach;
      endforeach;
      
      if(empty($urlParams)):
         return $html;
      endif;
      
      $html = preg_replace('/src="(.*?)"/', 'src="$1' . $urlParams . '"', $html);
      
      return $html;
   }
}