<?php
/**
 * @author     Koen Slagter
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Widget;

use Magento\Framework\App\ObjectManager;
use Magento\Framework\Serialize\Serializer\Json;

class Video extends \Magento\Framework\View\Element\Template implements \Magento\Widget\Block\BlockInterface
{
   protected $_template = 'widget/video.phtml';
   
   /**
    * @var Json
    */
   protected $serializer;
   
   /**
    * @param Context $context
    * @param Json $serializer
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      Json $serializer = null
   ) {
      $this->serializer = $serializer ?: ObjectManager::getInstance()->get(Json::class);
      
      parent::__construct($context);
   }
   
   /**
    * Retrieve the video json
    *
    * @return array
    */
   public function getJson()
   {
      if(!($json = $this->getData('json')) || empty($json)):
         return false;
      endif;
   
      $json = htmlspecialchars_decode($json, ENT_QUOTES);
      
      return $this->serializer->unserialize($json);
   }
}