<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Widget;

use Magento\Framework\App\ObjectManager;
use Magento\Framework\Serialize\Serializer\Json;
use Totem\Settings\Helper\Data as TotemHelper;

class Usp extends \Magento\Framework\View\Element\Template implements \Magento\Widget\Block\BlockInterface
{
   protected $_template = 'widget/usp.phtml';
   
   /**
    * @var Json
    */
   private $_serializer;
   
   /**
    * @var TotemHelper
    */
   protected $totemHelper;
   
   /**
    * @param Context $context
    * @param Json $serializer
    * @param TotemHelper $totemHelper
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      Json $serializer = null,
      TotemHelper $totemHelper
   )
   {
      $this->_serializer   = $serializer ?: ObjectManager::getInstance()->get(Json::class);
      $this->totemHelper   = $totemHelper;
      
      parent::__construct($context);
   }
   
   /**
    * Retrieve the Usp's
    *
    * @return array
    */
   public function getUsp()
   {
      $value = $this->totemHelper->getConfig('totem_settings/general/usp');
      if (is_string($value) && !empty($value)):
         return $this->_serializer->unserialize($value);
      else:
         return [];
      endif;
   }
}