<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Widget\Products;

class ProductsSlider extends \Totem\Widgets\Block\Widget\Products
{
   protected $_template = 'widget/products-slider.phtml';
   
   /**
    * Get key pieces for caching block content
    *
    * @return array
    */
   public function getCacheKeyInfo()
   {
      $conditions = $this->getData('conditions')
         ? $this->getData('conditions')
         : $this->getData('conditions_encoded');
   
      return [
         'TOTEM_WIDGETS_PRODUCTS_SLIDER',
         $this->_storeManager->getStore()->getId(),
         $this->getData('title'),
         $this->getData('subtitle'),
         $this->getSortBy(),
         $this->getSortOrder(),
         $this->getPageSize(),
         $conditions,
         $this->json->serialize($this->getRequest()->getParams())
      ];
   }
}