<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Widget\Products;

class ProductsGrid extends \Totem\Widgets\Block\Widget\Products
{
   const DEFAULT_PAGE_SIZE = 6;
   
   protected $_template = 'widget/products-grid.phtml';
   
   /**
    * Get key pieces for caching block content
    *
    * @return array
    */
   public function getCacheKeyInfo()
   {
      $conditions = $this->getData('conditions')
         ? $this->getData('conditions')
         : $this->getData('conditions_encoded');
   
      return [
         'TOTEM_WIDGETS_PRODUCTS_GRID',
         $this->_storeManager->getStore()->getId(),
         $this->getData('title'),
         $this->getData('subtitle'),
         $this->getSortBy(),
         $this->getSortOrder(),
         $this->getPageSize(),
         $conditions,
         $this->json->serialize($this->getRequest()->getParams())
      ];
   }
}