<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Widget;

class Categories extends \Magento\Framework\View\Element\Template implements \Magento\Widget\Block\BlockInterface
{
   const DEFAULT_IMAGE_WIDTH  = 250;
   const DEFAULT_IMAGE_HEIGHT = 250;
   
   /**
    * \Magento\Catalog\Model\CategoryFactory $categoryFactory
    */
   protected $categoryFactory;
   
   /**
    * \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $collectionFactory
    */
   protected $collectionFactory;
   
   /**
    * @param \Magento\Framework\View\Element\Template\Context $context
    * @param \Magento\Catalog\Model\CategoryFactory $categoryFactory
    * @param \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $collectionFactory
    * @param array $data
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      \Magento\Catalog\Model\CategoryFactory $categoryFactory,
      \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $collectionFactory
   ) {
      $this->categoryFactory     = $categoryFactory;
      $this->collectionFactory   = $collectionFactory;
      
      parent::__construct($context);
   }
   
   /**
    * Retrieve current store categories
    *
    * @return \Magento\Framework\Data\Tree\Node\Collection|\Magento\Catalog\Model\Resource\Category\Collection|array
    */
   public function getCategoryCollection()
   {
      $category = $this->categoryFactory->create();
      
      $categoryId = (int) preg_replace("/[^0-9]/","", $this->getData('parent_category'));
      
      if(!($categoryId > 0)):
         $categoryId = $this->_storeManager->getStore()->getRootCategoryId();
      endif;
      
      $category->load($categoryId);
      
      $childCategories = $this->_getChildrenCategories($category);
      
      return $childCategories;
   }
   
   /**
    * Get the width of category image
    * @return int
    */
   public function getImageWidth()
   {
      if($this->getData('image_width')==''):
         return self::DEFAULT_IMAGE_WIDTH;
      endif;
      
      return (int) $this->getData('image_width');
   }
   
   /**
    * Get the height of category image
    * @return int
    */
   public function getImageHeight()
   {
      if($this->getData('image_height')==''):
         return self::DEFAULT_IMAGE_HEIGHT;
      endif;
      
      return (int) $this->getData('image_height');
   }
   
   /**
    * Show category image or not
    * @return boolean
    */
   public function showCategoryImage()
   {
      if($this->getData('show_image') == 'image'):
         return true;
      endif;
      
      return false;
   }
   
   /**
    * Return child categories
    *
    * @param \Magento\Catalog\Model\Category $category
    *
    * @return \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory
    */
   private function _getChildrenCategories($category)
   {
      $collection = $this->collectionFactory->create();
      $collection->addAttributeToSelect('url_key')
                 ->addAttributeToSelect('name')
                 ->addAttributeToSelect('image')
                 ->addAttributeToSelect('thumbnail')
                 ->addAttributeToSelect('image_icon')
                 ->addAttributeToFilter('is_active', 1)
                 ->addIdFilter($category->getChildren())
                 ->addUrlRewriteToResult();
      
      return $collection;
   }
}