<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\View\Element;

use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\Framework\View\Element\BlockInterface;
use Magento\Framework\View\Element\RendererList;

class CustomRendererList extends RendererList
{
   protected $_widgetName;
   
   /**
    * Retrieve renderer by code
    *
    * @param string $type
    * @param string $default
    * @param string $rendererTemplate
    *
    * @return bool|AbstractBlock
    *
    * @throws \RuntimeException
    */
   public function getRenderer($type, $default = null, $rendererTemplate = null)
   {
      /** @var \Magento\Framework\View\Element\Template $renderer */
      $renderer = null;
      if($type == Configurable::TYPE_CODE):
         $renderer = $this->getLayout()
                          ->createBlock('Totem\Widgets\Block\Renderer\Listing\Configurable')
                          ->setWidgetName($this->getWidgetName())
                          ->setTemplate('Totem_Widgets::widget/product/listing/renderer.phtml');
      else:
         $renderer = $this->getChildBlock($type) ?: $this->getLayout()->createBlock('Magento\Framework\View\Element\Template');
      endif;
      
      if(!$renderer instanceof BlockInterface):
         throw new \RuntimeException('Renderer for type "' . $type . '" does not exist.');
      endif;
      
      $renderer->setRenderedBlock($this);
      
      if(!isset($this->rendererTemplates[$type])):
         $this->rendererTemplates[$type] = $renderer->getTemplate();
      else:
         $renderer->setTemplate($this->rendererTemplates[$type]);
      endif;
      
      if($rendererTemplate):
         $renderer->setTemplate($rendererTemplate);
      endif;
      
      return $renderer;
   }
   
   public function getWidgetName()
   {
      return $this->_widgetName;
   }
   
   public function setWidgetName($widgetName)
   {
      $this->_widgetName = $widgetName;
      return $this;
   }
   
}