<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Renderer\Listing;

class Configurable extends \Magento\Swatches\Block\Product\Renderer\Listing\Configurable
{
   protected $_widgetName;
   
   /**
    * @return string
    */
   public function getCacheKey()
   {
      return parent::getCacheKey() . '-' . $this->getWidgetName();
   }
   
   public function getWidgetName()
   {
      return $this->_widgetName;
   }
   
   public function setWidgetName($widgetName)
   {
      $this->_widgetName = $widgetName;
      
      return $this;
   }
}