<?php
/**
 * @author     Koen Slagter
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Widgets
 */

namespace Totem\Widgets\Block\Adminhtml\Widget;

class VideoCheck extends \Magento\Backend\Block\Widget\Form\Element
{
   /**
    * Prepare video widget html
    *
    * @param \Magento\Framework\Data\Form\Element\AbstractElement $element Form Element
    *
    * @return \Magento\Framework\Data\Form\Element\AbstractElement
    */
   public function prepareElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
   {
      $element->setData('after_element_html', $this->getHtml());

      return $element;
   }
   
   protected function getHtml()
   {
      $urlField            = 'input[name="parameters[url]"]';
      $jsonField           = 'input[name="parameters[json]"]';
      $invalidUrlMessage   = __('Please fill in a (valid) video URL');
      
      $html = "<script>
         function videoChecker() {
            var url = jQuery('" . $urlField . "').val();
            if (url.includes('youtu')|url.includes('vimeo')) {
               jQuery.getJSON('https://noembed.com/embed', {
                  format: 'json',
                  url: url
               }, function(data) {
                  if(data.title) {
                     jQuery('.note.admin__field-note:last').html('<h3>' + data.title + '</h3><br />' + data.html);
                     jQuery('button.add-widget').prop('disabled', false);
                     jQuery('" . $jsonField . "').val(JSON.stringify(data));
                  }
                  else {
                     jQuery('.note.admin__field-note:last').html('<h3>" . $invalidUrlMessage . "</h3>');
                     jQuery('button.add-widget').prop('disabled', true);
                     jQuery('" . $jsonField . "').val('');
                  }
               });
            }
            else {
               jQuery('.note.admin__field-note:last').html('<h3>" . $invalidUrlMessage . "</h3>');
               jQuery('button.add-widget').prop('disabled', true);
               jQuery('" . $jsonField . "').val('');
            }
         }
         jQuery('" . $urlField . "').on('input', function() {
            videoChecker();
         });
         videoChecker();
      </script>";
      
      return $html;
   }
}