<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Settings
 */

namespace Totem\Settings\Plugin;

class WysiwygConfigPlugin
{
   /**
    * @var \Magento\Ui\Block\Wysiwyg\ActiveEditor
    */
   protected $activeEditor;
   
   /**
    * @param \Magento\Ui\Block\Wysiwyg\ActiveEditor $activeEditor
    */
   public function __construct(
      \Magento\Ui\Block\Wysiwyg\ActiveEditor $activeEditor
   ) {
      $this->activeEditor = $activeEditor;
   }
   
   /**
    * Return WYSIWYG configuration
    *
    * @param \Magento\Ui\Component\Wysiwyg\ConfigInterface $configInterface
    * @param \Magento\Framework\DataObject $result
    *
    * @return \Magento\Framework\DataObject
    */
   public function afterGetConfig(
      \Magento\Ui\Component\Wysiwyg\ConfigInterface $configInterface,
      \Magento\Framework\DataObject $result
   ) {
      // Get current wysiwyg adapter's path
      $editor = $this->activeEditor->getWysiwygAdapterPath();
      
      // Is the current wysiwyg tinymce v4?
      if(strpos($editor,'tinymce4Adapter') === false):
         return $result;
      endif;
      
      if(($result->getDataByPath('settings/menubar')) || ($result->getDataByPath('settings/toolbar')) || ($result->getDataByPath('settings/plugins'))):
         // do not override ui_element config
         return $result;
      endif;
      
      $settings = $result->getData('tinymce4');
      
      if (!is_array($settings)):
         $settings = [];
      endif;
      
      // configure tinymce settings
      $settings['toolbar'] = 'formatselect | bold italic underline | alignleft aligncenter alignright | bullist numlist | link anchor | table image hr charmap | code';
      $settings['plugins'] = 'advlist anchor autolink charmap code contextmenu hr link lists media noneditable paste table';
      
      $result->setData('tinymce4', $settings);
      
      return $result;
   }
}