<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2020 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Settings
 */

namespace Totem\Settings\Plugin;

use Totem\Settings\Helper\Data as Helper;
use Magento\TwoFactorAuth\Model\TfaSession;

class BypassTwoFactorAuth
{
   /**
    * @var Helper
    */
   private $helper;
   
   /**
    * @param Helper $helper
    */
   public function __construct(
      Helper $helper
   ) {
      $this->helper = $helper;
   }
   
   /**
    * If the TwoFactorAuth Enable setting is set to false, always return true here so all requests bypass 2FA.
    * Otherwise, return the original result.
    *
    * @param TfaSession $subject
    * @param $result
    * @return bool
    */
   public function afterIsGranted(TfaSession $subject, $result): bool
   {
      return !$this->helper->getConfig('twofactorauth/general/enable', true)
         ? true
         : $result;
   }
}