<?php
/**
 * @author     Koen Slagter
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Settings
 */

namespace Totem\Settings\Model\Observer;

use Totem\Settings\Helper\Data as SettingsHelper;

class RemoveDefaultFooter implements \Magento\Framework\Event\ObserverInterface
{
   /**
    * @var SettingsHelper
    */
   protected $settingsHelper;
   
   public function __construct(
      SettingsHelper $settingsHelper
   ) {
      $this->settingsHelper = $settingsHelper;
   }
   
   /**
    * @param \Magento\Framework\Event\Observer $observer
    */
   public function execute(\Magento\Framework\Event\Observer $observer)
   {
      if(!$this->settingsHelper->getConfig('totem_settings/footer/custom_footer', true)):
         return;
      endif;
      
      /** @var \Magento\Framework\View\Layout $layout */
      $layout = $observer->getLayout();
      $layout->unsetElement('footer.row');
      $layout->unsetElement('form.subscribe');
   }
}