<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Settings
 */

namespace Totem\Settings\Block;

use Magento\Framework\View\Element\Template;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Serialize\Serializer\Json;
use Totem\Settings\Helper\Data as SettingsHelper;

class Usp extends Template
{
   /**
    * @var Json
    */
   private $_serializer;
   
   /**
    * @var SettingsHelper
    */
   protected $settingsHelper;
   
   /**
    * @param Context $context
    * @param Json $serializer
    * @param SettingsHelper $settingsHelper
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      Json $serializer = null,
      SettingsHelper $settingsHelper
   )
   {
      $this->_serializer      = $serializer ?: ObjectManager::getInstance()->get(Json::class);
      $this->settingsHelper   = $settingsHelper;
      
      parent::__construct($context);
   }
   
   /**
    * Retrieve the Usp's
    *
    * @return array
    */
   public function getUsp()
   {
      $value = $this->settingsHelper->getConfig('totem_settings/general/usp');
      if(!$this->settingsHelper->isVariableSet($value)):
         return [];
      endif;

      return $this->_serializer->unserialize($value);
   }
}