<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Settings
 */

namespace Totem\Settings\Block;

use Magento\Framework\View\Element\Template;
use Totem\Settings\Helper\Data as SettingsHelper;

class AddThis extends Template
{
   /**
    * @var SettingsHelper
    */
   protected $settingsHelper;
   
   /**
    * @param Context $context
    * @param Json $serializer
    * @param SettingsHelper $settingsHelper
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      SettingsHelper $settingsHelper
   )
   {
      $this->settingsHelper = $settingsHelper;
      
      parent::__construct($context);
   }
   
   /**
    * Retrieve title
    *
    * @return array
    */
   public function getTitle()
   {
      if(!$this->settingsHelper->getConfig('totem_settings/addthis/enabled', true)):
         return false;
      endif;
      
      $title = trim($this->settingsHelper->getConfig('totem_settings/addthis/title'));
   
      if(!$this->settingsHelper->isVariableSet($title)):
         return false;
      endif;
      
      return $title;
   }
   
   /**
    * Retrieve AddThis data
    *
    * @return array
    */
   public function getSettings()
   {
      if(!$this->settingsHelper->getConfig('totem_settings/addthis/enabled', true)):
         return false;
      endif;
      
      $profileId        = trim($this->settingsHelper->getConfig('totem_settings/addthis/profile_id'));
      $shareButtonsCode = trim($this->settingsHelper->getConfig('totem_settings/addthis/share_buttons_code'));
      
      if(!$this->settingsHelper->isVariableSet($profileId)):
         return false;
      endif;
   
      if(!$this->settingsHelper->isVariableSet($shareButtonsCode)):
         return false;
      endif;
      
      return [
         'profile_id'         => $profileId,
         'share_buttons_code' => $shareButtonsCode
      ];
   }
}