<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Ui\Component\Listing\DataProviders\Menu;

use Magento\Ui\DataProvider\AbstractDataProvider;
use Totem\MenuManager\Model\ResourceModel\Menu\CollectionFactory;

class ListProvider extends AbstractDataProvider
{
   /**
    * ListProvider constructor.
    *
    * @param string $name
    * @param string $primaryFieldName
    * @param string $requestFieldName
    * @param CollectionFactory $collectionFactory
    * @param array $meta
    * @param array $data
    */
   public function __construct(
      $name,
      $primaryFieldName,
      $requestFieldName,
      CollectionFactory $collectionFactory,
      array $meta = [],
      array $data = []
   ) {
      parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
      
      $this->collection = $collectionFactory->create();
   }
}
