<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Ui\Component\Listing\Column;

use Magento\Store\Ui\Component\Listing\Column\Store\Options;

/**
 * Store Options for Menu's
 */
class StoreOptions extends Options
{
   /**
    * All Store Views value
    */
   const ALL_STORE_VIEWS = '0';
   
   /**
    * Get options
    *
    * @return array
    */
   public function toOptionArray()
   {
      if ($this->options !== null):
         return $this->options;
      endif;
      
      $this->currentOptions['All Store Views']['label'] = __('All Store Views');
      $this->currentOptions['All Store Views']['value'] = self::ALL_STORE_VIEWS;
      
      $this->generateCurrentOptions();
      
      $this->options = array_values($this->currentOptions);
      
      return $this->options;
   }
}
