<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\UrlInterface;

class MenuActions extends \Magento\Ui\Component\Listing\Columns\Column
{
   /**
    * Url path
    */
   const URL_PATH_EDIT     = 'totem_menumanager/menu/edit';
   const URL_PATH_DELETE   = 'totem_menumanager/menu/delete';
   
   /**
    * @var UrlInterface
    */
   protected $urlBuilder;
   
   /**
    * @param ContextInterface   $context
    * @param UiComponentFactory $uiComponentFactory
    * @param UrlInterface       $urlBuilder
    * @param array              $components
    * @param array              $data
    */
   public function __construct(
      ContextInterface $context,
      UiComponentFactory $uiComponentFactory,
      UrlInterface $urlBuilder,
      array $components = [],
      array $data = []
   ) {
      $this->urlBuilder = $urlBuilder;
      
      parent::__construct($context, $uiComponentFactory, $components, $data);
   }
   
   /**
    * Prepare Data Source
    *
    * @param array $dataSource
    * @return array
    */
   public function prepareDataSource(array $dataSource)
   {
      if (isset($dataSource['data']['items'])):
         foreach ($dataSource['data']['items'] as & $item):
            if (isset($item['menu_id'])):
               $identifier = $item['identifier'];
               $item[$this->getData('name')] = [
                  'edit' => [
                     'href' => $this->urlBuilder->getUrl(
                        static::URL_PATH_EDIT,
                        [
                           'id' => $item['menu_id']
                        ]
                     ),
                     'label' => __('Edit')
                  ],
                  'delete' => [
                     'href' => $this->urlBuilder->getUrl(
                        static::URL_PATH_DELETE,
                        [
                           'id' => $item['menu_id']
                        ]
                     ),
                     'label' => __('Delete'),
                     'confirm' => [
                        'title' => __('Delete %1', $identifier),
                        'message' => __('Are you sure you want to delete the menu with identifier "%1"?', $identifier)
                     ]
                  ]
               ];
            endif;
         endforeach;
      endif;
      
      return $dataSource;
   }
}
