<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Setup;

use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeData implements UpgradeDataInterface
{
   protected $nodeCollection;
   
   public function __construct(
      \Totem\MenuManager\Model\ResourceModel\Menu\Node\CollectionFactory $nodeCollection
   ) {
      $this->nodeCollection   = $nodeCollection;
   }
   
   /**
    * {@inheritdoc}
    *
    * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
    */
   public function upgrade(
      ModuleDataSetupInterface $setup,
      ModuleContextInterface $context
   ) {
      $setup->startSetup();
      
      if (version_compare($context->getVersion(), '2.0.0', '<')):
         $this->_mergeData($setup);
      endif;
   
      $setup->endSetup();
   }
   
   /**
    * @param ModuleDataSetupInterface $setup
    */
   private function _mergeData(ModuleDataSetupInterface $setup)
   {

      $connection = $setup->getConnection();
      $configData = $setup->getTable('totem_menumanager_node');
      
      $collection = $this->nodeCollection->create();
      $nodes      = [];
      foreach ($collection as $node):
         $nodes[$node->getNodeId()]          = $node->getData();
         $nodes[$node->getNodeId()]['level'] = null;
      endforeach;
   
      foreach($nodes as $nodeId => $node):
         $level   = $this->_getLevel($nodes, $nodeId);
         $content = false;
         switch($node['type']):
            case 'cms_page':
               $content = $node['cms_page_identifier'];
               
               break;
            case 'category':
               $content = $node['category_id'];
               
               break;
            case 'custom_url':
            default:
               break;
         endswitch;
         
         if($content):
            $connection->update($configData, ['content' => $content, 'level' => $level], 'node_id = ' . $nodeId);
         else:
            $connection->update($configData, ['level' => $level], 'node_id = ' . $nodeId);
         endif;
      endforeach;
   }
   
   /**
    * @param $nodes
    * @param $nodeId
    *
    * @return int
    */
   private function _getLevel(&$nodes, $nodeId)
   {
      $level      = 0;
      $originalId = $nodeId;
      while($nodes[$nodeId]['parent_id']):
         if($nodes[$nodeId]['level'] !== null):
            $level += $nodes[$nodeId]['level'];
            
            break;
         endif;
         
         $nodeId = $nodes[$nodeId]['parent_id'];
         
         $level++;
      endwhile;
      
      $nodes[$originalId]['level'] = $level;
      
      return $level;
   }
}