# [Totem MenuManager Module] by Abovo Media
Provides powerful menu editor to replace category based menus in Magento 2.

## Requirements
  * Magento Community Edition 2.2.x

## Installation Method 1 - Installing via composer
  * Open command line
  * Using command "cd" navigate to your magento2 root directory
  * Run command: composer require totem/module-menumanager  

## Installation Method 2 - Installing using archive
  * Download [ZIP Archive](https://bitbucket.org/abovomedia_satis/module-menumanager/downloads/)
  * Extract files
  * In your Magento 2 root directory create folder app/code/Totem/MenuManager
  * Copy files and folders from archive to that folder
  * In command line, using "cd", navigate to your Magento 2 root directory
  * Run commands:
```
php bin/magento setup:upgrade
php bin/magento setup:di:compile
php bin/magento setup:static-content:deploy
```

## Use
List of menu's is located in Admin Panel under `Content > Design > Menu Manager`.

Following example shows how to replace default Magento 2 menu, by the user-defined menu with identifier `main_menu`.

```xml
<referenceBlock name="catalog.topnav" remove="true"/>
<referenceBlock name="store.menu">
  <block name="main.menu" class="Totem\MenuManager\Block\Menu">
     <arguments>
        <argument name="identifier" xsi:type="string">main_menu</argument>
     </arguments>
  </block>
</referenceBlock>
```

## Overwriting templates per menu ID
You have to add new folder with menu ID and add same structure like in default folder. For example, to overwrite templates of menu with ID `main_menu` the folders structure should looks like this:
```
Totem_MenuManager  
  └─ templates
    └─ main_menu
      └─ html
         │- menu
         │  │- node_type
         │  │  │- category.phtml
         │  │  └─ ...   
         │  └─ sub_menu.phtml
         └─ menu.phtml
```

## Adding new types of nodes
To add new type node you have to add new backend block that also implements `\Totem\MenuManager\Api\NodeTypeInterface`.

Backend block will be directly injected into menu editor.
Menu editor is using Vue.js so you need to create a new vue component that has node type code as name in `view/adminhtml/web/vue/menu-type` and load it in `view/adminhtml/templates/tab/menu/nodes.phtml`
(See `view/adminhtml/web/vue/menu-type/category.vue` for reference)

Newly created block with additional method should be added via `di.xml` defining block instance and node type code (code will be stored in database).

```xml
<?xml version="1.0" encoding="UTF-8" ?>
<config xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="urn:magento:framework:ObjectManager/etc/config.xsd">
    <type name="Totem\MenuManager\Model\NodeTypeProvider">
        <arguments>
            <argument name="providers" xsi:type="array">
                <item name="my_node_type" xsi:type="object">Vendor\Package\Block\NodeType\MyNode</item>
            </argument>
        </arguments>
    </type>
</config>
```

## Available endpoints: 
   
 * `/rest/V1/menus`: retrieves available menus
 * `/rest/V1/nodes`: retrieves nodes by menuId
 