<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Totem\MenuManager\Model\ResourceModel\Menu\CollectionFactory;

class Menu implements OptionSourceInterface
{
   /**
    * @var CollectionFactory
    */
   private $collectionFactory;
   
   /**
    * Constructor
    * @param CollectionFactory $collectionFactory
    */
   public function __construct(
      CollectionFactory $collectionFactory)
   {
      $this->collectionFactory = $collectionFactory;
   }
   
   /**
    * Get options
    *
    * @return array
    */
   public function toOptionArray()
   {
      $options = [];
      $menus   = $this->collectionFactory->create();
      foreach($menus as $menu):
         $options[] = [
            'value' => $menu->getIdentifier(),
            'label' => $menu->getTitle()
         ];
      endforeach;
      
      return $options;
   }
}