<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class RemoveCatalogTopnav implements ObserverInterface
{
   protected $_scopeConfig;
   
   public function __construct(
      \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
   ) {
      $this->_scopeConfig = $scopeConfig;
   }
   
   public function execute(Observer $observer)
   {
      /** @var \Magento\Framework\View\Layout $layout */
      $layout     = $observer->getLayout();
      $block      = $layout->getBlock('catalog.topnav');
      $customMenu = (bool)$this->_scopeConfig->getValue('totem_menumanager/settings/custom_menu', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
      if ($block && $customMenu):
         $layout->unsetElement('catalog.topnav');
      endif;
   }
}