<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model;

class NodeTypeProvider
{
   /**
    * @var array
    */
   private $providers;
   
   /**
    * NodeTypeProvider constructor.
    *
    * @param array $providers
    */
   public function __construct(array $providers = [])
   {
      $this->providers = $providers;
   }
   
   /**
    * @param $type
    * @param $nodes
    */
   public function prepareData($type, $nodes)
   {
      $this->providers[$type]->fetchData($nodes);
   }
   
   /**
    * @param string $type
    * @return \Totem\MenuManager\Api\NodeTypeInterface
    */
   public function getProvider($type)
   {
      return $this->providers[$type];
   }
   
   /**
    * @param $type
    * @param $id
    * @param $level
    *
    * @return mixed
    */
   public function render($type, $id, $level)
   {
      return $this->providers[$type]->getHtml($id, $level);
   }
   
   /**
    * @return array
    */
   public function getLabels()
   {
      $result = [];
      foreach ($this->providers as $code => $instance):
         $result[$code] = $instance->getLabel();
      endforeach;
      
      return $result;
   }
   
   /**
    * @return array
    */
   public function getEditForms()
   {
      return $this->providers;
   }
}
