<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\NodeType;

class CustomUrl extends AbstractNode
{
   /**
    * @inheritDoc
    */
   public function fetchConfigData()
   {
      return [];
   }
   
   /**
    * @inheritDoc
    */
   public function fetchData(array $nodes, $storeId)
   {
      $this->profiler->start(__METHOD__);
      
      $localNodes = [];
      
      foreach ($nodes as $node):
         $localNodes[$node->getId()] = $node;
      endforeach;
      
      $this->profiler->stop(__METHOD__);
      
      return $localNodes;
   }
}