<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\NodeType;

class CmsPage extends AbstractNode
{
   /**
    * @inheritDoc
    */
   protected function _construct()
   {
      $this->_init(\Totem\MenuManager\Model\ResourceModel\NodeType\CmsPage::class);
      
      parent::_construct();
   }
   
   /**
    * @inheritDoc
    */
   public function fetchConfigData()
   {
      $this->profiler->start(__METHOD__);
      
      $options        = $this->getResource()->fetchConfigData();
      $fieldOptions   = [];
      
      foreach ($options as $label => $value):
         $fieldOptions[] = [
            'label' => $label,
            'value' => $value
         ];
      endforeach;
      
      $data = [
         'totemMenuManagerAutoCompleteField' => [
            'type'     => 'cms_page',
            'options'  => $fieldOptions,
            'message'  => __('CMS Page not found'),
         ],
      ];
      
      $this->profiler->stop(__METHOD__);
      
      return $data;
   }
   
   /**
    * @inheritDoc
    */
   public function fetchData(array $nodes, $storeId)
   {
      $this->profiler->start(__METHOD__);
      
      $localNodes = [];
      $pagesCodes = [];
      
      foreach ($nodes as $node):
         $localNodes[$node->getId()] = $node;
         $pagesCodes[] = $node->getContent();
      endforeach;
      
      /** @var \Totem\MenuManager\Model\ResourceModel\NodeType\CmsPage $resource */
      $resource   = $this->getResource();
      $pageIds    = $resource->getPageIds($storeId, $pagesCodes);
      $pageUrls   = $resource->fetchData($storeId, $pageIds);
      
      $this->profiler->stop(__METHOD__);
      
      return [$localNodes, $pageIds, $pageUrls];
   }
}
