<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\NodeType;

class CmsBlock extends AbstractNode
{
   /**
    * @inheritDoc
    */
   protected function _construct()
   {
      $this->_init(\Totem\MenuManager\Model\ResourceModel\NodeType\CmsBlock::class);
      
      parent::_construct();
   }
   
   /**
    * @inheritDoc
    */
   public function fetchConfigData()
   {
      $this->profiler->start(__METHOD__);
      
      $options       = $this->getResource()->fetchConfigData();
      
      $fieldOptions  = [];
      
      foreach ($options as $label => $value):
         $fieldOptions[] = [
            'label' => $label,
            'value' => $value
         ];
      endforeach;
      
      $data = [
         'totemMenuManagerAutoCompleteField' => [
            'type'    => 'cms_block',
            'options' => $fieldOptions,
            'message' => __('CMS Block not found'),
         ],
      ];
      
      $this->profiler->stop(__METHOD__);
      
      return $data;
   }
   
   /**
    * @inheritDoc
    */
   public function fetchData(array $nodes, $storeId)
   {
      $this->profiler->start(__METHOD__);
      
      $localNodes    = [];
      $blocksCodes   = [];
      
      foreach ($nodes as $node):
         $localNodes[$node->getId()] = $node;
         $blocksCodes[] = $node->getContent();
      endforeach;
      
      $codes         = $this->getResource()->fetchData($storeId, $blocksCodes);
      
      $content       = [];
      foreach ($codes as $row):
         $content[$row['identifier']] = $row['content'];
      endforeach;
      
      $this->profiler->stop(__METHOD__);
      
      return [$localNodes, $content];
   }
}
