<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\Menu\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class IsActive
 */
class IsActive implements OptionSourceInterface
{
    /**
     * @var \Totem\MenuManager\Model\Menu
     */
    protected $menu;

    /**
     * Constructor
     *
     * @param \Totem\MenuManager\Model\Menu $menu
     */
    public function __construct(\Totem\MenuManager\Model\Menu $menu)
    {
        $this->menu = $menu;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $availableOptions  = $this->menu->getAvailableStatuses();
        $options           = [];
        
        foreach ($availableOptions as $key => $value):
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        endforeach;
        
        return $options;
    }
}
