<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Model\Menu;

use Totem\MenuManager\Model\ResourceModel\Menu\CollectionFactory;
use Magento\Framework\App\Request\DataPersistorInterface;

/**
 * Class DataProvider
 */
class DataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
   /**
    * @var \Totem\MenuManager\Model\ResourceModel\Menu\Collection
    */
   protected $collection;
   
   /**
    * @var DataPersistorInterface
    */
   protected $dataPersistor;
   
   /**
    * @var array
    */
   protected $loadedData;
   
   /**
    * Constructor
    *
    * @param string $name
    * @param string $primaryFieldName
    * @param string $requestFieldName
    * @param CollectionFactory $menuCollectionFactory
    * @param DataPersistorInterface $dataPersistor
    * @param FileInfo $fileInfo
    * @param array $meta
    * @param array $data
    */
   public function __construct(
      $name,
      $primaryFieldName,
      $requestFieldName,
      CollectionFactory $menuCollectionFactory,
      DataPersistorInterface $dataPersistor,
      array $meta = [],
      array $data = []
   ) {
      $this->collection    = $menuCollectionFactory->create();
      $this->dataPersistor = $dataPersistor;
      
      parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
   }
   
   /**
    * Get data
    *
    * @return array
    */
   public function getData()
   {
      if (isset($this->loadedData)):
         return $this->loadedData;
      endif;
      
      $items = $this->collection->getItems();
      /** @var \Totem\MenuManager\Model\Menu $menu */
      foreach ($items as $menu):
         $menu->setData('stores', $menu->getStores());
         $this->loadedData[$menu->getId()]['menu'] = $menu->getData();
      endforeach;
      
      $data = $this->dataPersistor->get('totem_menumanager_menu');
      if (!empty($data)):
         $menu = $this->collection->getNewEmptyItem();
         $menu->setData($data);
         $this->loadedData[$menu->getId()]['menu'] = $menu->getData();
         $this->dataPersistor->clear('totem_menumanager_menu');
      endif;
      
      return $this->loadedData;
   }
}
