<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Controller\Adminhtml\Menu;

use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

class Index extends \Magento\Backend\App\Action
{
   const ADMIN_RESOURCE = 'Totem_MenuManager::menumanager';
   
   /**
    * @var PageFactory
    */
   protected $resultPageFactory;
   
   /**
    * @param Context     $context
    * @param PageFactory $resultPageFactory
    */
   public function __construct(
      Context $context,
      PageFactory $resultPageFactory
   ) {
      parent::__construct($context);
      
      $this->resultPageFactory = $resultPageFactory;
   }
   
   /**
    * @return \Magento\Backend\Model\View\Result\Page|\Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
      $resultPage = $this->resultPageFactory->create();
      $resultPage->setActiveMenu('Totem_MenuManager::menumanager');
      $resultPage->addBreadcrumb(__('Menu Manager'), __('Menu Manager'));
      $resultPage->addBreadcrumb(__('Manage Menus'), __('Manage Menus'));
      $resultPage->getConfig()->getTitle()->prepend(__('Menu Manager'));
   
      return $resultPage;
   }
}
