<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Controller\Adminhtml\Menu;

use Magento\Backend\App\Action;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Totem\MenuManager\Api\MenuRepositoryInterface;

class Edit extends Action
{
   const ADMIN_RESOURCE = 'Totem_MenuManager::menumanager';
   
   const REGISTRY_CODE = 'totem_menumanager_menu';
   
   /**
    * @var MenuRepositoryInterface
    */
   private $menuRepository;
   
   /**
    * @var Registry
    */
   private $registry;
   
   /**
    * @param Action\Context          $context
    * @param MenuRepositoryInterface $menuRepository
    * @param Registry                $registry
    */
   public function __construct(
      Action\Context $context,
      MenuRepositoryInterface $menuRepository,
      Registry $registry
   ) {
      parent::__construct($context);
      
      $this->menuRepository   = $menuRepository;
      $this->registry         = $registry;
   }
   
   /**
    * Dispatch request
    *
    * @return \Magento\Framework\Controller\ResultInterface|ResponseInterface
    * @throws \Magento\Framework\Exception\NotFoundException
    */
   public function execute()
   {
      $id = $this->getRequest()->getParam('id');
      try
      {
         $model   = $this->menuRepository->getById($id);
         $this->registry->register(self::REGISTRY_CODE, $model);
         
         $result  = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
         $result->setActiveMenu('Totem_MenuManager::menumanager');
         $result->getConfig()->getTitle()->prepend(__('Edit Menu %1', $model->getTitle()));
      }
      catch (NoSuchEntityException $e)
      {
         $result = $this->resultRedirectFactory->create();
         $result->setPath('*/*/index');
      }
      
      return $result;
   }
}