<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Controller\Adminhtml\Menu;

use Magento\Backend\App\Action;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;

class Create extends Action
{
   const ADMIN_RESOURCE = 'Totem_MenuManager::menumanager';
   
   /**
    * Dispatch request
    *
    * @return \Magento\Framework\Controller\ResultInterface|ResponseInterface
    * @throws \Magento\Framework\Exception\NotFoundException
    */
   public function execute()
   {
      $result = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
      $result->setActiveMenu('Totem_MenuManager::menumanager');
      $result->getConfig()->getTitle()->prepend(__('Create new menu'));
      
      return $result;
   }
}