<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\View\Element\Html\Link;

class Current extends \Magento\Framework\View\Element\Html\Link\Current
{
   protected function _toHtml()
   {
      if(false != $this->getTemplate()):
         return parent::_toHtml();
      endif;
      
      $highlight = '';
      
      if($this->getIsHighlighted() || $this->isCurrent()):
         $highlight = ' active';
      endif;
      
      $html  = '<li class="nav item' . $highlight . '"><a href="' . $this->escapeHtml($this->getHref()) . '"';
      $html .= $this->getTitle() ? ' title="' . $this->escapeHtml((string)new \Magento\Framework\Phrase($this->getTitle())) . '"' : '';
      $html .= $this->getAttributesHtml() . '>';
      
      if ($this->getIsHighlighted()):
         $html .= '<strong>';
      endif;
      
      $html .= $this->escapeHtml((string)new \Magento\Framework\Phrase($this->getLabel()));
      
      if ($this->getIsHighlighted()):
         $html .= '</strong>';
      endif;
      
      $html .= '</a></li>';
      
      return $html;
   }
}