<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 * @deprecated Since 2.0.0, for new method see README.md
 */

namespace Totem\MenuManager\Block;

class Topmenu extends \Totem\MenuManager\Block\Menu
{
   /**
    * @var string
    */
   protected $_template = 'Totem_MenuManager::main_menu/html/menu.phtml';
   
   /**
    * @param \Magento\Framework\View\Element\Template\Context                $context
    * @param \Magento\Framework\Event\Manager                                $eventManager
    * @param \Totem\MenuManager\Api\MenuRepositoryInterface                  $menuRepository
    * @param \Totem\MenuManager\Api\NodeRepositoryInterface                  $nodeRepository
    * @param \Totem\MenuManager\Model\NodeTypeProvider                       $nodeTypeProvider
    * @param \Totem\MenuManager\Model\TemplateResolver                       $templateResolver
    * @param \Magento\Catalog\Api\CategoryRepositoryInterface                $categoryRepository
    * @param \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $categoryCollection
    * @param \Totem\MenuManager\Model\Menu\NodeFactory                       $nodeFactory
    * @param NodeType\Category                                               $nodeCategory
    * @param NodeType\CmsPage                                                $nodeCmsPage
    * @param NodeType\Product                                                $nodeProduct
    * @param NodeType\CustomUrl                                              $nodeCustomUrl
    * @param array                                                           $data
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      \Magento\Framework\Event\Manager $eventManager,
      \Totem\MenuManager\Api\MenuRepositoryInterface $menuRepository,
      \Totem\MenuManager\Api\NodeRepositoryInterface $nodeRepository,
      \Totem\MenuManager\Model\NodeTypeProvider $nodeTypeProvider,
      \Totem\MenuManager\Model\TemplateResolver $templateResolver,
      \Magento\Catalog\Api\CategoryRepositoryInterface $categoryRepository,
      \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $categoryCollection,
      \Totem\MenuManager\Model\Menu\NodeFactory $nodeFactory,
      \Totem\MenuManager\Block\NodeType\Category $nodeCategory,
      \Totem\MenuManager\Block\NodeType\CmsPage $nodeCmsPage,
      \Totem\MenuManager\Block\NodeType\Product $nodeProduct,
      \Totem\MenuManager\Block\NodeType\CustomUrl $nodeCustomUrl,
      array $data = []
   ) {
      parent::__construct($context, $eventManager, $menuRepository, $nodeRepository, $nodeTypeProvider, $templateResolver, $categoryRepository, $categoryCollection, $nodeFactory, $nodeCategory, $nodeCmsPage, $nodeProduct, $nodeCustomUrl, $data);
      
      $this->submenuTemplate = $this->getMenuTemplate(
         'Totem_MenuManager::main_menu/html/menu/sub_menu.phtml'
      );
   }
}
