<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\NodeType;

use Magento\Framework\View\Element\Template\Context;
use Magento\Cms\Model\Template\FilterProvider;
use Totem\MenuManager\Model\TemplateResolver;
use Totem\MenuManager\Model\NodeType\CmsBlock as CmsBlockModel;

class CmsBlock extends AbstractNode
{
   /**
    * @var string
    */
   protected $defaultTemplate = 'html/menu/node_type/cms_block.phtml';
   
   /**
    * @var string
    */
   protected $nodeType = 'cms_block';
   
   /**
    * @var array
    */
   protected $nodes;
   
   /**
    * @var array
    */
   protected $content;
   
   /**
    * {@inheritdoc}
    */
   protected $viewAllLink = false;
   
   /**
    * @var FilterProvider
    */
   private $filterProvider;
   
   /**
    * @var CmsBlockModel
    */
   private $_cmsBlockModel;
   
   /**
    * @param Context $context
    * @param CmsBlockModel $cmsBlockModel
    * @param FilterProvider $filterProvider
    * @param TemplateResolver $templateResolver
    * @param array $data
    */
   public function __construct(
      Context $context,
      CmsBlockModel $cmsBlockModel,
      FilterProvider $filterProvider,
      TemplateResolver $templateResolver,
      $data = []
   ) {
      parent::__construct($context, $templateResolver, $data);
      
      $this->filterProvider = $filterProvider;
      $this->_cmsBlockModel = $cmsBlockModel;
   }
   
   /**
    * @return string
    */
   public function getJsonConfig()
   {
      $data = $this->_cmsBlockModel->fetchConfigData();
      
      return $data;
   }
   
   /**
    * @param array $nodes
    */
   public function fetchData(array $nodes)
   {
      $storeId = $this->_storeManager->getStore()->getId();
      
      list($this->nodes, $this->content) = $this->_cmsBlockModel->fetchData($nodes, $storeId);
   }
   
   /**
    * @param int $nodeId
    * @param int $level
    *
    * @return mixed|string
    */
   public function getHtml($nodeId, $level)
   {
      $node    = $this->nodes[$nodeId];
      $storeId = $this->_storeManager->getStore()->getId();
      
      if (isset($this->content[$node->getContent()])):
         $content = $this->content[$node->getContent()];
         $content = $this->filterProvider->getBlockFilter()->setStoreId($storeId)->filter($content);
         
         return $content;
      endif;
      
      return '';
   }
   
   /**
    * @return \Magento\Framework\Phrase
    */
   public function getLabel()
   {
      return __("Cms Block");
   }
}
