<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Html;

class Topmenu extends \Magento\Theme\Block\Html\Topmenu
{
   protected $recursionLevel;
   
   protected function _toHtml()
   {
      $this->setModuleName($this->extractModuleName(\Magento\Theme\Block\Html\Topmenu::class));
      
      return parent::_toHtml();
   }
   
   /**
    * Recursively generates top menu html from data that is specified in $menuTree
    *
    * @param \Magento\Framework\Data\Tree\Node $menuTree
    * @param string $childrenWrapClass
    * @param int $limit
    * @param array $colBrakes
    * @return string
    *
    * @SuppressWarnings(PHPMD.CyclomaticComplexity)
    * @SuppressWarnings(PHPMD.NPathComplexity)
    */
   protected function _getHtml(\Magento\Framework\Data\Tree\Node $menuTree, $childrenWrapClass, $limit, array $colBrakes = []
   ) {
      $html                      = '';
      
      $children                  = $menuTree->getChildren();
      $childLevel                = 0;
      
      $this->recursionLevel      = max(
         0,
         (int)$this->_scopeConfig->getValue(
            'totem_menumanager/settings/max_depth',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
         )
      );
      
      $html .= '<li class="level-root active">';
      $html .= '<div class="level-' . $childLevel . '-wrapper">';
      $html .= '<div class="level-' . $childLevel . '-container">';
      $html .= '<ul class="level-' . $childLevel . '">';
      
      foreach($children as $child):
         if ($child->getData('is_parent_active') === false):
            continue;
         endif;
         
         $child->setLevel($childLevel);
         
         $html .= '<li ' . $this->_getRenderedMenuItemAttributes($child) . '>';
         $html .= '<a href="' . $child->getUrl() . '"><span>' . $this->escapeHtml($child->getName());
         $html .= '</span></a>';
         $html .= $this->_addSubMenu(
            $child,
            $childLevel + 1
         );
         $html .= '</li>';
      endforeach;
      
      $html .= '</ul>';
      $html .= '</div>';
      $html .= '</div>';
      $html .= '</li>';
      
      return $html;
   }
   
   /**
    * Add sub menu HTML code for current menu item
    *
    * @param \Magento\Framework\Data\Tree\Node $child
    * @param string $childLevel
    * @param string $childrenWrapClass
    * @param int $limit
    * @return string HTML code
    */
   protected function _addSubMenu($child, $childLevel, $childrenWrapClass = '', $limit = 0)
   {
      $html = '';
      
      if($childLevel > $this->recursionLevel):
         return $html;
      endif;
      
      if(!$child->hasChildren()):
         return $html;
      endif;
      
      $html .= '<i class="submenu-indicator"></i>';
      $html .= '<div class="level-' . $childLevel . '-wrapper">';
      $html .= '<div class="level-' . $childLevel . '-container">';
      $html .= '<ul class="level-' . $childLevel . '">';
      
      $html .= $this->_getSubHtml($child, $childLevel);
      
      $html .= '</ul>';
      $html .= '</div>';
      $html .= '</div>';
      
      return $html;
   }
   
   /**
    * Returns array of menu item's classes
    *
    * @param \Magento\Framework\Data\Tree\Node $item
    * @return array
    */
   protected function _getMenuItemClasses(\Magento\Framework\Data\Tree\Node $item)
   {
      $classes          = [];
      
      $levelClassPrefix = $this->getItemLevelClassPrefix() ?: 'level-';
      $activeClass      = $this->getActiveItemClass() ?: 'active';
      $hasActiveClass   = $this->getHasActiveItemClass() ?: 'active';
      $parentClass      = $this->getParentItemClass() ?:'parent';
      
      $classes[]        = $levelClassPrefix . $item->getLevel();
      
      if ($item->getIsActive()):
         $classes[] = $activeClass;
      elseif ($item->getHasActive()):
         $classes[] = $hasActiveClass;
      endif;
      
      if ($item->getClass()):
         $classes[] = $item->getClass();
      endif;
      
      if ($item->hasChildren()):
         $classes[] = $parentClass;
      endif;
      
      return $classes;
   }
   
   /**
    * Recursively generates top menu html from data that is specified in $menuTree
    *
    * @param \Magento\Framework\Data\Tree\Node $menuTree
    * @param string $childrenWrapClass
    * @param int $limit
    * @param array $colBrakes
    *
    * @return string
    *
    * @SuppressWarnings(PHPMD.CyclomaticComplexity)
    * @SuppressWarnings(PHPMD.NPathComplexity)
    */
   private function _getSubHtml(\Magento\Framework\Data\Tree\Node $menuTree, $childLevel)
   {
      $html                      = '';
      $children                  = $menuTree->getChildren();
      
      foreach($children as $child):
         $child->setLevel($childLevel);
         
         $html .= '<li ' . $this->_getRenderedMenuItemAttributes($child) . '>';
         $html .= '<a href="' . $child->getUrl() . '"><span>' . $this->escapeHtml($child->getName()) . '</span></a>';
         $html .= $this->_addSubMenu(
            $child,
            $childLevel + 1
         );
         $html .= '</li>';
      endforeach;
      
      return $html;
   }
}