<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Adminhtml\Menu\Edit\Tab;

use Magento\Backend\Block\Template;
use Magento\Framework\Registry;
use Totem\MenuManager\Api\NodeRepositoryInterface;
use Totem\MenuManager\Controller\Adminhtml\Menu\Edit;
use Totem\MenuManager\Model\NodeTypeProvider;

class Nodes extends Template
{
   protected $_template = 'tab/menu/nodes.phtml';
   
   /**
    * @var Registry
    */
   private $registry;
   
   /**
    * @var NodeRepositoryInterface
    */
   private $nodeRepository;
   
   /**
    * @var NodeTypeProvider
    */
   private $nodeTypeProvider;
   
   /**
    * @param Template\Context        $context
    * @param NodeRepositoryInterface $nodeRepository
    * @param NodeTypeProvider        $nodeTypeProvider
    * @param Registry                $registry
    * @param array                   $data
    */
   public function __construct(
      Template\Context $context,
      NodeRepositoryInterface $nodeRepository,
      NodeTypeProvider $nodeTypeProvider,
      Registry $registry,
      array $data = []
   ) {
      parent::__construct($context, $data);
      
      $this->registry         = $registry;
      $this->nodeRepository   = $nodeRepository;
      $this->nodeTypeProvider = $nodeTypeProvider;
   }
   
   /**
    * @return array|void
    */
   public function renderNodes()
   {
      $menu = $this->registry->registry(Edit::REGISTRY_CODE);
      $data = [];
      
      if ($menu):
         $nodes = $this->nodeRepository->getByMenu($menu->getId());
         
         if (!empty($nodes)):
            foreach ($nodes as $node) :
               $level   = $node->getLevel();
               $parent  = $node->getParentId() ?: 0;
               
               if (!isset($data[$level])):
                  $data[$level] = [];
               endif;
               
               if (!isset($data[$level][$parent])):
                  $data[$level][$parent] = [];
               endif;
               
               $data[$level][$parent][] = $node;
            endforeach;
            
            return $this->renderNodeList(0, null, $data);
         endif;
      endif;
      
      return $data;
   }
   
   /**
    * @param $level
    * @param $parent
    * @param $data
    *
    * @return array|void
    */
   private function renderNodeList($level, $parent, $data)
   {
      if (is_null($parent)):
         $parent = 0;
      endif;
      
      if (empty($data[$level])):
         return;
      endif;
      
      if (empty($data[$level][$parent])):
         return;
      endif;
      
      $nodes = $data[$level][$parent];
      
      foreach ($nodes as $node):
         $menu[] = [
            'type'            => $node->getType(),
            'content'         => $node->getContent(),
            'classes'         => $node->getClasses(),
            'button'          => $node->getButton(),
            'align'           => $node->getAlign(),
            'target'          => $node->getTarget(),
            'subcategories'   => $node->getSubcategories(),
            'id'              => $node->getId(),
            'title'           => $node->getTitle(),
            'columns'         => $this->renderNodeList($level + 1, $node->getId(), $data) ? $this->renderNodeList($level + 1, $node->getId(), $data) : []
         ];
      endforeach;
      
      return $menu;
   }
   
   /**
    * Get Node forms
    *
    * @return mixed
    */
   public function getNodeForms()
   {
      return $this->nodeTypeProvider->getEditForms();
   }
   
   /**
    * Get Node labels
    *
    * @return mixed
    */
   public function getNodeLabels()
   {
      return $this->nodeTypeProvider->getLabels();
   }
   
   /**
    * Get Node buttons
    *
    * @return array
    */
   public function getNodeButtons()
   {
      return [
         ['value' => 'btn-primary',   'label' => __('Primary')],
         ['value' => 'btn-secondary', 'label' => __('Secondary')]
      ];
   }
   
   /**
    * Get Node aligns
    *
    * @return array
    */
   public function getNodeAligns()
   {
      return [
         ['value' => 'right', 'label' => __('Right')]
      ];
   }
}
