<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Adminhtml\Menu\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class SaveButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      $data = [
         'label'           => __('Save Menu'),
         'class'           => 'save primary',
         'data_attribute'  => [
            'mage-init'       => ['button' => ['event' => 'save']],
            'form-role'       => 'save'
         ],
         'sort_order'      => 90
      ];
      
      return $data;
   }
}
