<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Adminhtml\Menu\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class SaveAndContinueButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      $data = [
         'label'           => __('Save and Continue Edit'),
         'class'           => 'save',
         'data_attribute'  => [
            'mage-init'       => ['button' => ['event' => 'saveAndContinueEdit']]
         ],
         'sort_order'      => 80
      ];
      
      return $data;
   }
}
