<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Adminhtml\Menu\Edit;

use Totem\MenuManager\Api\MenuRepositoryInterface;

class GenericButton
{
   /**
    * Url Builder
    *
    * @var \Magento\Framework\UrlInterface
    */
   protected $urlBuilder;
   
   /**
    * @var MenuRepositoryInterface
    */
   protected $menuRepository;
   
   /**
    * @param \Magento\Backend\Block\Widget\Context $context
    * @param MenuRepositoryInterface $menuRepository
    */
   public function __construct(
      \Magento\Backend\Block\Widget\Context $context,
      MenuRepositoryInterface $menuRepository
   ) {
      $this->request        = $context->getRequest();
      $this->urlBuilder     = $context->getUrlBuilder();
      $this->menuRepository = $menuRepository;
   }
   
   /**
    * Return menu ID
    *
    * @return int|null
    */
   public function getMenuId()
   {
      if(!$id = $this->request->getParam('id')):
         return null;
      endif;
      
      try
      {
         return $this->menuRepository->getById($id)->getId();
      }
      catch (NoSuchEntityException $e)
      {
      }
      
      return null;
   }
   
   /**
    * Generate url by route and parameters
    *
    * @param   string $route
    * @param   array $params
    * @return  string
    */
   public function getUrl($route = '', $params = [])
   {
      return $this->urlBuilder->getUrl($route, $params);
   }
}
