<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Adminhtml\Menu\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class DeleteButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      $data = [];
      if($this->getMenuId()):
         $data = [
            'label'        => __('Delete Menu'),
            'class'        => 'delete',
            'on_click'     => 'deleteConfirm(\'' . __(
                  'Are you sure you want to do this?'
               ) . '\', \'' . $this->getDeleteUrl() . '\', {"data": {}})',
            'sort_order'   => 20
         ];
      endif;
      
      return $data;
   }
   
   /**
    * @return string
    */
   public function getDeleteUrl()
   {
      return $this->getUrl('*/*/delete', ['id' => $this->getMenuId()]);
   }
}
