<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Block\Adminhtml\Menu\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class BackButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      $data = [
         'label'        => __('Back'),
         'on_click'     => sprintf("location.href = '%s';", $this->getBackUrl()),
         'class'        => 'back',
         'sort_order'   => 10
      ];
      
      return $data;
   }
   
   /**
    * Get URL for back (reset) button
    *
    * @return string
    */
   public function getBackUrl()
   {
      return $this->getUrl('*/*/');
   }
}
