<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Api;

use Totem\MenuManager\Api\Data\NodeInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

interface NodeRepositoryInterface
{
   /**
    * @param \Totem\MenuManager\Api\Data\NodeInterface $page
    * @return \Totem\MenuManager\Api\Data\NodeInterface
    */
   public function save(NodeInterface $page);
   
   /**
    * @param int $id
    * @return \Totem\MenuManager\Model\Menu\Node
    */
   public function getById($id);
   
   /**
    * @param \Magento\Framework\Api\SearchCriteriaInterface $criteria
    * @return \Magento\Framework\Api\SearchResultsInterface
    */
   public function getList(SearchCriteriaInterface $criteria);
   
   /**
    * @param \Totem\MenuManager\Api\Data\NodeInterface $page
    * @return bool
    */
   public function delete(NodeInterface $page);
   
   /**
    * @param int $id
    * @return bool
    */
   public function deleteById($id);
   
   /**
    * Return node by menu id
    *
    * @api
    * @param int $menuId
    * @return \Totem\MenuManager\Api\Data\NodeInterface[]
    */
   public function getByMenu($menuId);
}
