<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Api;

use Totem\MenuManager\Api\Data\MenuInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

interface MenuRepositoryInterface
{
   /**
    * @param \Totem\MenuManager\Api\Data\MenuInterface $page
    * @return \Totem\MenuManager\Api\Data\MenuInterface
    */
   public function save(MenuInterface $page);
   
   /**
    * @param int $id
    * @return \Totem\MenuManager\Model\Menu
    */
   public function getById($id);
   
   /**
    * Returns menus list
    *
    * @api
    * @param \Magento\Framework\Api\SearchCriteriaInterface $criteria
    * @return \Totem\MenuManager\Api\Data\MenuSearchResultsInterface
    */
   public function getList(SearchCriteriaInterface $criteria);
   
   /**
    * @param \Totem\MenuManager\Api\Data\MenuInterface $page
    * @return bool
    */
   public function delete(MenuInterface $page);
   
   /**
    * @param int $id
    * @return bool
    */
   public function deleteById($id);
   
   /**
    * @param string $identifier
    * @param array $storeIds
    * @return \Totem\MenuManager\Model\Menu
    */
   public function get($identifier, $storeIds);
}
