<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Api\Data;

interface NodeTypeInterface
{
   /**
    * Fetch additional data required for rendering nodes.
    *
    * @param array $nodes
    * @param int|string $storeId
    *
    * @return mixed
    */
   public function fetchData(array $nodes, $storeId);
   
   /**
    * Fetch additional data required for config.
    *
    * @return mixed
    */
   public function fetchConfigData();
}