<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_MenuManager
 */

namespace Totem\MenuManager\Api\Data;

use Magento\Framework\Api\SearchResultsInterface;

/**
 * Search results interface.
 *
 * @api
 */
interface MenuSearchResultsInterface extends SearchResultsInterface
{
   /**
    * Get pages list.
    *
    * @return \Totem\MenuManager\Api\Data\MenuInterface[]
    */
   public function getItems();
   
   /**
    * Set pages list.
    *
    * @param \Totem\MenuManager\Api\Data\MenuInterface[] $items
    * @return $this
    */
   public function setItems(array $items);
}
