# [Totem ImageResizer Module] by Abovo Media

Magento 2 Module to add simple image resizing capabilities in all blocks and .phtml templates

## Requirements
  * PHP >= 7.0.*
  * Magento Community Edition 2.2.x

## Installation Method 1 - Installing via composer
  * Open command line
  * Using command "cd" navigate to your magento2 root directory
  * Run command: composer require totem/module-imageresizer  

## Installation Method 2 - Installing using archive
  * Download [ZIP Archive](https://bitbucket.org/abovomedia_satis/module-imageresizer/downloads/)
  * Extract files
  * In your Magento 2 root directory create folder app/code/Totem/ImageResizer
  * Copy files and folders from archive to that folder
  * In command line, using "cd", navigate to your Magento 2 root directory
  * Run commands:
```
php bin/magento setup:upgrade
php bin/magento setup:di:compile
php bin/magento setup:static-content:deploy
```

## Usage
`ImageResizer` is automatically available in all frontend Blocks. 
You can resize your images just calling a method:

```php
/** @var \Totem\ImageResizer\Model\Resizer $imageResizer */
$imageResizer     = $block->getImageResizer();
$resizedImageUrl  = $imageResizer->resizeAndGetUrl(<originalImageUrl>, $width, $height, [$resizeSettings]); 
```

You can do that directly on the .phtml or in your custom Block.

## Cache
Resized images are saved in cache to improve performance. That way, if an image was already resized, we just use the one in cache.

If you need to, you can clear the resized images cache on the System Cache Management underneath the Additional Cache Management